<header class="p-3 mb-3 border-bottom">
    <div class="container">
        <div class="d-flex flex-wrap align-items-center justify-content-center justify-content-lg-start">
            <a href="/" class="d-flex align-items-center mb-2 mb-lg-0 text-dark text-decoration-none">
                <svg class="bi me-2" width="40" height="32" role="img" aria-label="Bootstrap">
                    <use xlink:href="#bootstrap"></use>
                </svg>
            </a>

            <ul class="nav col-12 col-lg-auto me-lg-auto mb-2 justify-content-center mb-md-0">

                <li>
                    <a href="{{ route('intranetIndex') }}"
                        class="nav-link px-2 link-dark  @if (Route::currentRouteName() == 'intranetIndex') current @endif">Home</a>
                </li>

                @php
                    $modules = Module::all();
                @endphp

                @foreach ($modules as $module)
                    @if ($module->isEnabled())
                        <li>
                            <a href="{{ route($module->getName() . ':index') }}"
                                class="nav-link px-2 link-dark @if (str_contains(Route::currentRouteName(), $module->getName())) current @endif">{{ $module->getName() }}</a>
                        </li>
                    @endif
                @endforeach
            </ul>

            @guest
                @if (Route::has('login'))
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('login') }}">{{ __('Login') }}</a>
                    </li>
                @endif

                @if (Route::has('register'))
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('register') }}">{{ __('Registrar') }}</a>
                    </li>
                @endif
            @else
                <div class="dropdown text-end">
                    <a href="#" class="d-block link-dark text-decoration-none dropdown-toggle d-flex align-self-center"
                        id="dropdownUser" data-bs-toggle="dropdown" aria-expanded="false">
                        {{-- <img src="https://mpsoft.com.br/assets/img/logo.png" alt="mdo" width="32" height="32" class="rounded-circle"> --}}
                        <div class="d-flex">
                            <div
                                style="margin-right: 5px;width:32px; height:32px; background-image:url(https://mpsoft.com.br/assets/img/logo.png); background-size:contain; background-repeat:no-repeat; background-position:center;">
                            </div>
                            {{ Auth::user()->name }}
                        </div>
                    </a>
                    <ul class="dropdown-menu text-small" aria-labelledby="dropdownUser">
                        <li><a class="dropdown-item" href="{{ route('intranetMinhaconta') }}">Minha conta</a></li>
                        @if(auth()->user()->id)<li><a class="dropdown-item" href="{{ route('intranetUsuarios') }}">Usuários</a></li>@endif
                        <li>
                            <hr class="dropdown-divider">
                        </li>
                        <li>
                            <a class="dropdown-item" href="{{ route('logout') }}"
                                onclick="event.preventDefault();
                                                                                 document.getElementById('logout-form').submit();">
                                {{ __('Logout') }}
                            </a>

                            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                @csrf
                            </form>
                        </li>
                    </ul>
                </div>
            @endguest
        </div>
    </div>
</header>
