@extends('intranet.layouts.app')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <table class="table table-striped" id="tabela">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Nome</th>
                        <th scope="col">E-mail</th>
                        <th scope="col">Data</th>
                        <th scope="col">Status</th>
                        <th scope="col"></th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($users as $user)
                        <tr>
                            <th scope="row">{{ $user->id }}</th>
                            <td>{{ $user->name }}</td>
                            <td>{{ $user->email }}</td>
                            <td>{{ date('d/m/Y', strtotime($user->created_at)) }}</td>
                            <td>@if ($user->status) Ativado @else Desativado @endif</td>
                            <td class="d-flex">
                                <a href="{{ route('intranetEditarusuario', $user->id) }}"><button
                                        class="btn btn-secondary">
                                        <ion-icon name="create-outline"></ion-icon>
                                    </button></a>
                                <form action="{{ route('intranetDestroyusuario', $user->id) }}" method="POST">
                                    @method('DELETE')
                                    @csrf
                                    <button type="submit" class="btn btn-danger">
                                        <ion-icon name="trash-outline"></ion-icon>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <a href="{{ route('intranetNovaconta') }}"><button class="btn btn-primary">Novo usuário</button></a>
        </div>
    </div>
@endsection


@section('script')
    <script>
        $("form").submit(function() {
            event.preventDefault();
            if (confirm("Tem certeza que deseja remover este usuário?")) {
                $(this).unbind('submit').submit();
            }
        });

        $(function() {
            $('#tabela').DataTable({
                language: {
                    url: '{{ asset('json/Portuguese-Brasil.json') }}'
                },
            });
        });
    </script>
@endsection
