@section('description', 'Dentista na sua casa. Saúde bucal rápida e segura para quem não pode ir ao consultório.')

@section('tags',
    'dentista na sua casa, dentista, saúde bucal, atendimento domiciliar, Hotéis geriátricos, Atendimento
    executivo, acompanhamento, tratamento, diagnóstico, avaliação',)
@section('image', asset('/img/logo.png'))

@extends('layouts.app')
@include('include.menu-atendimento')
@section('content')
@section('head')
    <link href="{{ asset('css/atendimento.css') }}" rel="stylesheet">
@endsection


<section id="slide">
    <div class="container-fuid">
        <div class="row justify-content-center w-100 text-center text-lg-start">
            <div class="col-12 col-lg-6 px-5">
                <h1>Dentista na sua casa</h1>
                <div class="row justify-content-center">
                    <div class="col-12 col-lg-8 me-auto">
                        <p class="mb-5 mt-3">
                            Saúde bucal rápida e segura para quem não pode ir ao consultório.
                        </p>
                        <a href="https://web.whatsapp.com/send?phone=5519993698413" target="_blank">Vamos conversar?</a>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-5"></div>
        </div>
    </div>
</section>

<section id="inicio">
    <div class="container-fluid">
        <div class="row justify-content-center text-center">
            <div class="col-10 col-md-9 col-lg-12 my-5 pb-5">
                <h2>Como funciona o Dentista na sua casa?</h2>
                <p class="mt-3">
                    Um pequeno vídeo que explica quase tudo.
                </p>
            </div>
            <div class="col-3 back2 d-none d-lg-block"></div>
            <div class="col-12 col-lg-6 video">
                <video controls="" poster="/img/preview-video.png" style="border-radius: 20px">
                    <source src="img/video.mp4" type="video/mp4">
                </video>
            </div>
            <div class="col-3 back1 d-none d-lg-block"></div>
        </div>
    </div>
</section>

<section id="trabalho" class="">
    <div class="container-fluid">
        <div class="row justify-content-center text-center text-lg-start px-xl-5 mx-xl-5 row1">
            <div class="col-12 col-md-10 col-lg-4 card1 ps-4">
                <div class="row justify-content-center">
                    <div class="col-12 my-4 my-lg-0">
                        <img src="/img/casa/icon1.png" class="img-fluid icones" alt="icone casa">
                    </div>
                    <div class="col-12 me-lg-auto ">
                        <h3>Atendimento domiciliar</h3>
                    </div>
                    <div class="col-11 col-lg-11 me-lg-auto mt-2 mb-2">
                        <p>
                            Nosso foco é levar conforto e saúde com todo amor, respeito, dedicação e empatia para quem
                            mais precisa. Serviços odontológicos de acordo com as normas de biosegurança e materiais
                            esterilizados.
                        </p>
                    </div>
                    <div class="col-12 mb-4">
                        <a href="https://web.whatsapp.com/send?phone=5519993698413" target="_blank">Agende uma visita <ion-icon class="arrow" name="chevron-forward"></a>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-10 col-lg-4 card2 ps-4">
                <div class="row justify-content-center">
                    <div class="col-12 my-4 my-lg-0">
                        <img src="/img/casa/icon2.png" class="img-fluid icones" alt="icone cama">
                    </div>
                    <div class="col-12">
                        <h3>Hotéis geriátricos</h3>
                    </div>
                    <div class="col-11 me-lg-auto mt-2 mb-2">
                        <p>
                            Atendimento odontológico especializado
                            em pacientes idosos e acamados.
                        </p>
                    </div>
                    <div class="col-12 mb-4">
                        <a href="https://web.whatsapp.com/send?phone=5519993698413" target="_blank">Seja nosso parceiro <ion-icon class="arrow" name="chevron-forward"></a>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-10 col-lg-4 card3 ps-4">
                <div class="row justify-content-center">
                    <div class="col-12 my-4 my-lg-0">
                        <img src="/img/casa/icon3.png" class="img-fluid icones" alt="icone executivo">
                    </div>
                    <div class="col-12 me-lg-auto">
                        <h3>Atendimento executivo</h3>
                    </div>
                    <div class="col-11 me-lg-auto mt-2 mb-2">
                        <p>
                            Sem tempo para salas de espera e deslocamento até a clínica? Nós vamos até a sua empresa.
                        </p>
                    </div>
                    <div class="col-12 mb-4">
                        <a href="https://web.whatsapp.com/send?phone=5519993698413" target="_blank">Agende uma visita <ion-icon class="arrow" name="chevron-forward"></a>
                    </div>
                </div>
            </div>
        </div>
        <div class="row justify-content-center text-center px-md-5 texto py-5 row2">
            <div class="col-12 mb-2">
                <h5>Como trabalhamos?</h5>
            </div>
            <div class="col-12 col-lg-9">
                <span>
                    Levamos o consultório até o conforto da sua casa, é uma experiência única e exclusiva para você.
                </span>
            </div>

            <div class="col-12 mt-5">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-md-3 col-sm-6">
                            <a class="botao-icon selected" data-id="avaliacao">
                                <div class="col-12 icon1 justify-content-center">
                                    <img class="img-icon-avaliacao" src="{{ asset('img/casa/icon4.png') }}"
                                        data-src="icon4" alt="">
                                </div>
                                <div class="col-12 mt-3 text-center text-break">
                                    <h4 class="texto-icon">Avaliação</h4>
                                </div>
                            </a>
                        </div>

                        <div class="col-md-3 col-sm-6">
                            <a class="botao-icon" data-id="diagnostico">
                                <div class="col-12 icon1 justify-content-center">
                                    <img class="img-icon-diagnostico" src="{{ asset('img/casa/icon5-1.png') }}"
                                        data-src="icon5" alt="">
                                </div>
                                <div class="col-12 mt-3 text-center text-break">
                                    <h4 class="texto-icon">Diagnóstico</h4>
                                </div>
                            </a>
                        </div>

                        <div class="col-md-3 col-sm-6">
                            <a class="botao-icon" data-id="tratamento">
                                <div class="col-12 icon1 justify-content-center">
                                    <img class="img-icon-tratamento" src="{{ asset('img/casa/icon6-1.png') }}"
                                        data-src="icon6" alt="">
                                </div>
                                <div class="col-12 mt-3 text-center text-break">
                                    <h4 class="texto-icon">Tratamento</h4>
                                </div>
                            </a>
                        </div>

                        <div class="col-md-3 col-sm-6">
                            <a  class="botao-icon" data-id="acompanhamento">
                                <div class="col-12 icon1 justify-content-center">
                                    <img class="img-icon-acompanhamento" src="{{ asset('img/casa/icon7-1.png') }}"
                                        data-src="icon7" alt="">
                                </div>
                                <div class="col-12 mt-3 text-center text-break">
                                    <h4 class="texto-icon">Acompanhamento</h4>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div id="avaliacao">
                    <div class="container">
                        <div class="row justify-content-center mt-5">
                            <div class="col-10 col-md-7 col-lg-4 col-xxl-5">
                                <div class="bloco-img mb-3 mb-lg-0">
                                    <img src="{{ asset('img/casa/img1.png') }}" class="img-fluid" alt="">
                                </div>
                            </div>
                            <div class="col-12 col-sm-10 col-lg-8 col-xxl-7">
                                <div class="bloco-texto d-flex align-items-start flex-column">
                                    <h5 class="text-light text-start text-break">Avaliação</h5>
                                    <p class="text-start mt-4">
                                        Vamos até o seu domicílio para realizar a consulta de avaliação e planejar o melhor tratamento para você ou para o seu familiar.
                                    </p>
                                    <div class="href mt-auto ms-auto p-2">
                                        <a href="https://web.whatsapp.com/send?phone=5519993698413" target="_blank">Agende uma visita</a>
                                        <ion-icon class="arrow" name="chevron-forward">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="diagnostico" style="display: none">
                    <div class="container">
                        <div class="row justify-content-center mt-5">
                            <div class="col-10 col-md-7 col-lg-4 col-xxl-5">
                                <div class="bloco-img mb-3 mb-lg-0">
                                    <img src="{{ asset('img/casa/img2.png') }}" class="img-fluid" alt="">
                                </div>
                            </div>
                            <div class="col-12 col-sm-10 col-lg-8 col-xxl-7">
                                <div class="bloco-texto d-flex align-items-start flex-column">
                                    <h5 class="text-light text-start text-break">Diagnóstico</h5>
                                    <p class="text-start mt-4">
                                        Após a avaliação, apresentamos o
                                        diagnóstico, opções do plano de tratamento
                                        e orçamento recomendados. Desta forma,
                                        o paciente ou o familiar responsável fica à
                                        vontade para definir a melhor alternativa.
                                    </p>
                                    <div class="href mt-auto ms-auto p-2">
                                        <a href="https://web.whatsapp.com/send?phone=5519993698413" target="_blank">Agende uma visita</a>
                                        <ion-icon class="arrow" name="chevron-forward">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="tratamento" style="display: none">
                    <div class="container">
                        <div class="row justify-content-center mt-5">
                            <div class="col-10 col-md-7 col-lg-4 col-xxl-5">
                                <div class="bloco-img mb-3 mb-lg-0">
                                    <img src="{{ asset('img/casa/img3.png') }}" class="img-fluid" alt="">
                                </div>
                            </div>
                            <div class="col-12 col-sm-10 col-lg-8 col-xxl-7">
                                <div class="bloco-texto d-flex align-items-start flex-column">
                                    <h5 class="text-light text-start text-break">Tratamento</h5>
                                    <p class="text-start mt-4">
                                        Realizado no domicílio do paciente de
                                        acordo com normas de segurança e
                                        materiais esterilizados.
                                    </p>
                                    <p class="text-start">
                                        Saiba mais sobre os nossos tratamentos
                                        mais frequentes aqui.
                                    </p>
                                    <div class="href mt-auto ms-auto p-2">
                                        <a href="https://web.whatsapp.com/send?phone=5519993698413" target="_blank">Agende uma visita</a>
                                        <ion-icon class="arrow" name="chevron-forward">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="acompanhamento" style="display: none">
                    <div class="container">
                        <div class="row justify-content-center mt-5">
                            <div class="col-10 col-md-7 col-lg-4 col-xxl-5">
                                <div class="bloco-img mb-3 mb-lg-0">
                                    <img src="{{ asset('img/casa/img4.png') }}" class="img-fluid" alt="">
                                </div>
                            </div>
                            <div class="col-12 col-sm-10 col-lg-8 col-xxl-7">
                                <div class="bloco-texto d-flex align-items-start flex-column">
                                    <h5 class="text-light text-start text-break">Acompanhamento</h5>
                                    <p class="text-start mt-4">
                                        É extremamente importante manter a
                                        qualidade do tratamento executado e a
                                        manutenção da saúde bucal. Oferecemos
                                        visitas periódicas e pronto-atendimento em
                                        casos de urgências.
                                    </p>
                                    <div class="href mt-auto ms-auto p-2">
                                        <a href="https://web.whatsapp.com/send?phone=5519993698413" target="_blank">Agende uma visita</a>
                                        <ion-icon class="arrow" name="chevron-forward">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section id="sobre" class="mb-5 mt-5 pt-5">
    <div class="container-fluid">
        <div class="row justify-content-center text-center text-lg-start">
            <div class="col-11 col-sm-10 col-lg-5 me-lg-5">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <h2>Quem somos?</h2>
                    </div>
                    <div class="col-12 my-2">
                        <h3>
                            Cuidar da saúde bucal é cuidar da saúde geral, afinal, o corpo humano é um sistema
                            integrado. Tem função preventiva e pode salvar vidas.
                        </h3>
                    </div>
                    <div class="col-12">
                        <p>
                            A Dra. Jéssica Carvalho é habilitada no atendimento odontológico a Pacientes com alterações
                            Sistêmicas, tais como pessoas idosas, pacientes acamados, com necessidades especiais,
                            transtornos psiquiátricos, baixa imunidade, residentes em casas de repouso para idosos,
                            hospitalizadas, levando praticidade, conforto, saúde e economia de tempo proporcionado pelo
                            atendimento odontológico home care.
                        </p>
                    </div>
                    <div class="col-12 col-lg-10 me-auto mt-5">
                        <h4>
                            “Cuidarei de você na comodidade e segurança do seu lar.”
                        </h4>
                    </div>
                    <div class="col-12">
                        <span>
                            Dra. Jéssica Carvalho - CRO 128.015
                        </span>
                    </div>
                </div>
            </div>
            <div class="col-9 col-sm-7 col-md-6 col-lg-4 mt-5 mt-lg-0">
                <img src="/img/jessica.png" class="img-fluid" alt="imagem dr. jessica carvalho">
            </div>
        </div>
    </div>
</section>

<section id="banner">
    <div class="container-fluid">
        <div class="row justify-content-center text-center">
            <div class="col-11 col-sm-10 col-lg-6 box">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <h2>Entre em contato</h2>
                    </div>
                    <div class="col-12 col-lg-10 my-3">
                        <p>
                            Mande uma mensagem a qualquer momento para tirar suas dúvidas e conversar.
                        </p>
                    </div>
                    <div class="col-12 mb-3">
                        <a href="https://web.whatsapp.com/send?phone=5519993698413" target="_blank">
                            <ion-icon class="icon" name="logo-whatsapp"></ion-icon> Agende uma consulta
                            <ion-icon class="arrow" name="chevron-forward">
                        </a>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

{{-- <section id="blog-meio">
    <div class="container">
        <div class="row justify-content-center align-items-center desc w-100">
            <div class="col-12 text-center texto-blog pt-5 pb-3">
                <div class="row justify-content-center">
                    <div class="col-12 pt-3">
                        <h4>Um pouco mais sobre odontologia</h4>
                    </div>
                    <div class="col-12 col-lg-9 mt-3">
                        <p>
                            O Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem
                            vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-lg-11" data-aos="fade-up">
                <div class="row">
                    <div id="owl-blog" class="owl-carousel owl-theme owl-loaded">
                        <div class="owl-stage-outer">
                            <div class="owl-stage quadro2">
                                <div class="owl-item ">
                                    <div class="row justify-content-center">
                                        <div class="ms-4 col-11 my-2 my-md-0">
                                            <div class="card">
                                                <div class="imagem-post"
                                                    style="background-image:url({{ $post->image }})"></div>
                                                <div class="card-body text-center">
                                                    <ion-icon name="calendar" style="color: #737373;"
                                                        class="icone  pe-2"></ion-icon><span style="color: #737373;"
                                                        class="datas"><?= date_format(date_create($post->updated_at), 'd/m/Y') ?></span>
                                                    <h5 class="card-title pt-2"><?= $post->title ?></h5>
                                                </div>
                                                <div class="row justify-content-center align-items-center g-0">
                                                    <div class="col-12 col-lg-5 text-center pb-3">
                                                        <a href="{{ route('postAtendimento', $post->id) }}"
                                                            class="btn btn-blog-mais">VER MAIS <ion-icon
                                                                name="caret-forward" class="icone-bt"></ion-icon>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- <div class="owl-nav">
                            <div class="owl-prev"></div>
                            <div class="owl-next"></div>
                        </div> -->
                    </div>
                </div>
            </div>
            <div class="col-12 text-center mb-5">
                <a href={{ route('blogAtendimento') }} class="btn btn-blog">Blog</a>
            </div>
        </div>
    </div>
</section> --}}

@include('include.parceiros')

<section id="contato">
    <div class="container-fluid">
        <div class="row justify-content-center row1 text-lg-start text-center">
            <div class="col-12 col-md-8 col-lg-5 me-lg-5 mt-lg-4">
                <div class="row justify-content-center ">
                    <h2>Nós vamos até você!</h2>
                    <p>
                        Nossa área de atuação principal é na
                        região de Campinas e Indaiatuba
                    </p>
                </div>
            </div>
            <div class="col-12 col-lg-4">
                <div class="row justify-content-center">
                    <div class="col-12 col-lg-1">
                        <ion-icon class="info-icon" name="logo-whatsapp"></ion-icon>
                    </div>
                    <div class="col-12 col-lg-11 my-2 pt-2 pt-lg-0 text-break">
                        <a href="https://api.whatsapp.com/send?phone=5519993698413" target="_blank">
                            <span>
                                (19) 9 9369-8413
                            </span>
                        </a>
                    </div>
                    <div class="col-12 col-lg-1 mt-2">
                        <ion-icon class="info-icon" name="mail"></ion-icon>
                    </div>
                    <div class="col-12 col-lg-11 my-3 pt-2 pt-lg-0 text-break">
                        <a href="mailto:contato@dentistanasuacasa.com.br">
                            <span>contato@dentistanasuacasa.com.br</span>
                        </a>
                    </div>
                    <div class="col-12 col-lg-1 text-break">
                        <ion-icon class="info-icon" name="location"></ion-icon>
                    </div>
                    <div class="col-12 col-lg-11 mt-2 pt-3 pt-lg-0 text-break">
                        <a href="https://g.page/dentista-na-sua-casa?share" target="_blank">
                            <span>
                                Indaiatuba, Campinas e região
                            </span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <iframe class="m-0" src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d469818.0197558803!2d-47.07772!3d-23.0804971!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x14103b4aca1c7276!2sDentista%20na%20sua%20casa!5e0!3m2!1spt-BR!2sbr!4v1648655479345!5m2!1spt-BR!2sbr" width="100%" height="350" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
</section>

@include('include.footer')
@endsection

@section('script')

<script>
    $(".botao-icon").click(function() {
        var id = $(this).attr('data-id');
        var selected = $('.selected');
        var selectedId = selected.attr('data-id');
        var img = $('.img-icon-' + id);
        var oldimg = $('.img-icon-' + selectedId);

        $(img).attr('src', `{{ asset('/img/casa') }}/` + $(img).attr('data-src') + '.png');
        $(oldimg).attr('src', `{{ asset('/img/casa') }}/` + $(oldimg).attr('data-src') + '-1.png');
        $('#' + selectedId).fadeOut('fast', function() {
            $('#' + id).fadeIn('fast');
        });
        $('.selected').removeClass('selected');
        $('[data-id="' + id + '"').addClass('selected');
    })
</script>

@endsection
