@section('description', "")

@section('tags', "")
@section('image', asset("/img/logo.png"))

@extends('layouts.app')
@section('title', 'Blog - ' . config('app.name'))
@include('include.menu-estetica')
@section('head')
<link href="{{ asset('css/blog.css') }}" rel="stylesheet">
<link href="{{ asset('css/menu-blog.css') }}" rel="stylesheet">
<link href="{{ asset('css/menu-atendimento.css') }}" rel="stylesheet">
@endsection

@section('content')

<div class="cor-roxa col-12 px-0">
    <div class="row justify-content-center text-center w-100">
        <div class="col-12 ">
            <h1 class="">Um pouco mais sobre odontologia</h1>
        </div>
        <div class="col-12 col-lg-8">
            <h2>
                O Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500.
            </h2>
        </div>
    </div>
</div>

<section id="blog-meio">
    <div class="container-fluid">
        <div class="row justify-content-center  g-0">
            <div class="col-12 col-md-10 col-lg-9 px-lg-4 text-center py-5 ">
                <div class="row justify-content-center justify-content-md-start text-center mt-5">

                    <?php foreach ($posts as $post) : ?>
                        <div class="col-10 col-md-5 mb-4">
                            <div class="card">
                                <div class="imagem-post" style="background-image:url({{ $post->image }})"></div>
                                <div class="card-body text-center col-10 col-lg-11 mx-auto">
                                    <span class="pb-3" style="color: #9F9F9F;">
                                        <ion-icon name="calendar" class="icone  pe-2"></ion-icon><?= date_format(date_create($post->created_at), 'd/m/Y') ?>
                                    </span>
                                    <h5 class="card-title pt-4"><?= $post->title ?></h5>
                                </div>
                                <div class="col-12 text-center pb-3 ps-3">
                                    <a href="{{ route('postEstetica', $post->id) }}" class="btn btn-blog-mais">VER MAIS <ion-icon name="caret-forward" class="icone-bt"></ion-icon></a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>

                </div>
            </div>

            <div class="col-8 col-sm-4 col-md-3 col-lg-2 pt-lg-5 mt-lg-5 mb-5 mb-lg-0">
                <h4 class="py-2 ps-3" class="wow fadeInRight text-center " data-wow-delay="1s">Arquivos</h4>
                {!! $arquivo !!}
            </div>

        </div>
    </div>
</section>

<section id="banner">
    <div class="container-fluid">
        <div class="row justify-content-center text-center w-100">
            <div class="col-11 col-md-9 col-lg-6 box">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <h2>Vamos trabalhar juntos?</h2>
                    </div>
                    <div class="col-12 col-lg-10 my-3">
                        <p>
                            Mande uma mensagem a qualquer momento para tirar suas dúvidas e conversar.
                        </p>
                    </div>
                    <div class="col-12 col-lg-4 mb-3 text-break">
                        <span>
                            <ion-icon class="icon" name="logo-whatsapp"></ion-icon> (19) 9 9369-8413
                        </span>
                    </div>
                    <div class="col-12 col-lg-5 mt-lg-1 mb-3 text-break">
                        <a href="" target="_blank">
                            Fale comigo agora mesmo <ion-icon class="arrow" name="chevron-forward">
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@include('include.footer')
@endsection