@section('description', "Dentista na sua casa. Saúde bucal rápida e segura para quem não pode ir ao consultório.")

@section('tags', "dentista na sua casa, dentista, saúde bucal, atendimento domiciliar, Hotéis geriátricos, Atendimento executivo, acompanhamento, tratamento, diagnóstico, avaliação")
@section('image', asset("/img/logo.png"))

@extends('layouts.app')
@include('include.menu-estetica')
@section('content')
@section('head')
<link href="{{ asset('css/estetica.css') }}" rel="stylesheet">
@endsection


<section id="slide">
    <div class="container-fluid">
        <div class="row justify-content-center text-center text-lg-end w-100">
            <div class="col-12 col-lg-5"></div>
            <div class="col-12 col-lg-6 px-sm-5">
                <h2 class="mx-auto me-lg-0 ms-auto px-lg-1">DENTISTA NA SUA CASA</h2>
                <h1 style="line-height: 40px">Tratamentos Estéticos em Casa</h1>
                <div class="row justify-content-center">
                    <div class="col-12 col-lg-8 ms-auto">
                        <p class="mb-5 mt-lg-0">
                            Permita-se sorrir !
                        </p>
                        <a href="https://web.whatsapp.com/send?phone=5519993698413" target="_blank">Vamos conversar?</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section id="inicio">
    <div class="container-fluid">
        <div class="row justify-content-center py-5 my-5">
            <div class="col-12 col-lg-5">
                <div class="row justify-content-center text-center text-lg-start">
                    <div class="col-12 mb-2 mb-lg-0 d-flex justify-content-lg-start  justify-content-center">
                        <h2 class="">COMO FUNCIONA?</h2>
                    </div>
                    <div class="col-12 col-lg-12">
                        <h3>Lentes em <span>resina composta</span></h3>
                    </div>
                    <div class="col-12 col-lg-9 me-auto">
                        <p>
                            A aplicação das lentes de resina composta
                            pode ser feita na sua casa.
                        </p>
                    </div>
                    <div class="col-12 col-lg-9 me-auto ms-sm-4 mt-4">
                        <div class="row justify-content-center">
                            <div class="col-12 col-lg-1 mt-1">
                                <ion-icon class="check" name="checkmark-circle"></ion-icon>
                            </div>
                            <div class="col-12 col-lg-11 my-2 ps-lg-4">
                                <h4>TRANSFORMADOR</h4>
                                <p>
                                    Sorriso perfeito em apenas uma sessão.
                                </p>
                            </div>
                            <div class="col-12 col-lg-1 mt-2">
                                <ion-icon class="check" name="checkmark-circle"></ion-icon>
                            </div>
                            <div class="col-12 col-lg-11 my-2 ps-lg-4">
                                <h4>INDOLOR E DE FÁCIL APLICAÇÃO</h4>
                                <p>
                                    Não requer anestesia ou desgaste de
                                    dentes naturais.
                                </p>
                            </div>
                            <div class="col-12 col-lg-1 mt-1">
                                <ion-icon class="check" name="checkmark-circle"></ion-icon>
                            </div>
                            <div class="col-12 col-lg-11 my-2 ps-lg-4">
                                <h4>DURABILIDADE</h4>
                                <p>
                                    Benefícios por muitos anos e podem ser facilmente
                                    substituídas.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-9 col-sm-7 col-lg-5 text-center text-lg-end">
                <img src="/img/estetico/img1.png" class="img-fluid w-100" alt="imagem de comparação de sorrisos de uma mulher">
            </div>
        </div>
    </div>
</section>

<div id="trabalhamos">
    <br><br>
</div>

<section id="trabalho" class="">
    <div class="container-fluid">
        <div class="row justify-content-center text-center text-lg-start px-xl-5 mx-xl-5 row1">
            <div class="col-12 col-md-9 col-lg-3 card1 ps-lg-4">
                <div class="row justify-content-center">
                    <div class="col-12 my-4 my-lg-0">
                        <img src="/img/estetico/icon1.png" class="img-fluid icones" alt="icone documento de avaliação">
                    </div>
                    <div class="col-12 col-lg-10 me-lg-auto">
                        <h3>Avaliação</h3>
                    </div>
                    <div class="col-12 col-lg-11 me-lg-auto mt-2 mb-4">
                        <ul>
                            <li>Personalização do plano de tratamento;</li>
                            <li>Orçamento.</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-9 col-lg-3 card2 ps-lg-4">
                <div class="row justify-content-center">
                    <div class="col-12 my-4 my-lg-0">
                        <img src="/img/estetico/icon2.png" class="img-fluid icones" alt="icone documento de checklist">
                    </div>
                    <div class="col-12  me-lg-auto">
                        <h3>Preparação</h3>
                    </div>
                    <div class="col-12 col-lg-11 me-lg-auto mt-2 mb-4">
                        <ul>
                            <li>Limpeza;</li>
                            <li>Clareamento.</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-9 col-lg-3 card3 ps-lg-4">
                <div class="row justify-content-center">
                    <div class="col-12 my-4 my-lg-0">
                        <img src="/img/estetico/icon3.png" class="img-fluid icones" alt="icone dente">
                    </div>
                    <div class="col-12 col-lg-8 me-lg-auto w-100">
                        <h3>Aplicação das Lentes</h3>
                    </div>
                    <div class="col-12 col-lg-12 me-lg-auto mt-2 mb-4">
                        <ul>
                            <li>Tempo médio de 4 horas de acordo com cada caso;</li>
                            <li>Indolor e sem anestesia.</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-9 col-lg-3 card4 ps-lg-4">
                <div class="row justify-content-center">
                    <div class="col-12 my-4 my-lg-0">
                        <img src="/img/estetico/icon4.png" class="img-fluid icones" alt="icone prancheta e um dente">
                    </div>
                    <div class="col-12">
                        <h3>Manutenção</h3>
                    </div>
                    <div class="col-12 col-lg-12 me-auto mt-2 mb-4">
                        <ul>
                            <li>A cada 6 meses para limpeza e um
                                polimento perfeito.
                                </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        {{-- <div class="row justify-content-center text-center row2">
            <div class="col-12 pt-5 mt-5 mb-4">
                <h5>Como trabalhamos?</h5>
            </div>
            <div class="col-12 col-sm-9 col-md-7 col-lg-4 mb-5 mb-lg-0 box">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <img src="/img/estetico/icon6.png" class="img-fluid" alt="icone rubi">
                    </div>
                    <div class="col-12 py-3">
                        <h2>Plano Rubi</h2>
                    </div>
                    <div class="col-12  text-start">
                        <div class="row justify-content-center">
                            <div class="col-1">
                                <ion-icon class="arrow" name="chevron-forward"></ion-icon>
                            </div>
                            <div class="col-11">
                                <h6>Materiais nacionais de alta qualidade</h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-12  text-start py-2">
                        <h6>
                            <ion-icon class="arrow" name="chevron-forward"></ion-icon> Limpeza completa
                        </h6>
                    </div>
                    <div class="col-12  text-start">
                        <h6>
                            <ion-icon class="arrow" name="chevron-forward"></ion-icon> Claramento
                        </h6>
                    </div>
                    <div class="col-12 mt-4">
                        <a href="https://web.whatsapp.com/send?phone=5519993698413" target="_blank" class="btn btn-planos">Escolher esse plano <ion-icon class="arrow2" name="chevron-forward"></ion-icon></a>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-9 col-md-7 col-lg-4 box ms-lg-4">
                <div class="row justify-content-center">
                    <div class="col-12 ">
                        <img src="/img/estetico/icon5.png" class="img-fluid" alt="icone rubi">
                    </div>
                    <div class="col-12 px-0 py-3">
                        <h2>Plano Diamante</h2>
                    </div>
                    <div class="col-12 text-start">
                        <div class="row justify-content-center">
                            <div class="col-1">
                                <ion-icon class="arrow" name="chevron-forward"></ion-icon>
                            </div>
                            <div class="col-11">
                                <h6> Materiais importados de última geração</h6>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 text-start py-2">
                        <h6>
                            <ion-icon class="arrow" name="chevron-forward"></ion-icon> Limpeza completa
                        </h6>
                    </div>
                    <div class="col-12 text-start">
                        <h6>
                            <ion-icon class="arrow" name="chevron-forward"></ion-icon> Claramento
                        </h6>
                    </div>
                    <div class="col-12 text-start pt-2">
                        <h6>
                            <ion-icon class="arrow" name="chevron-forward"></ion-icon> Primeira revisão incluída
                        </h6>
                    </div>
                    <div class="col-12 mt-5">
                        <a href="https://web.whatsapp.com/send?phone=5519993698413" class="btn btn-planos2" target="_blank">Escolher esse plano <ion-icon class="arrow2" name="chevron-forward"></ion-icon></a>
                    </div>
                </div>
            </div>
        </div> --}}
    </div>
</section>

<section id="sobre" class="mb-5 mt-5 pt-0">
    <div class="container-fluid">
        <div class="row justify-content-center text-center text-lg-start">
            {{-- <div class="col-12 text-center">
                <span>Comissão de 15% para clínicas estéticas parceiras.</span>
            </div> --}}
            <div class="col-12 col-lg-4 esquerda">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <h3>Dra.</h3>
                    </div>
                    <div class="col-12">
                        <h2>JÉSSICA CARVALHO</h2>
                    </div>
                    <div class="col-12">
                        <p>CRO 128.015</p>
                    </div>
                    <div class="col-12">
                        <ul>
                            <li>Cirurgiã Dentista desde 2018.</li>
                            <li>Experiência de 9 anos em atendimento a pacientes em home care.</li>
                            <li>Especialização em ortodontia.</li>
                            <li>Membro da academia da odontologia sistêmica.</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-9 col-sm-7 col-md-6 col-lg-4 direita">
                <img src="/img/jessica.png" class="img-fluid" alt="imagem dr. jessica carvalho">
            </div>
        </div>
    </div>
</section>

{{-- <section id="blog-meio">
    <div class="container">
        <div class="row justify-content-center align-items-center desc w-100">
            <div class="col-12 text-center texto-blog pt-5 pb-3">
                <div class="row justify-content-center">
                    <div class="col-12 pt-5">
                        <h4>Um pouco mais sobre odontologia</h4>
                    </div>
                    <div class="col-12 col-lg-9 mt-3">
                        <p>
                            O Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-lg-11" data-aos="fade-up">
                <div class="row">
                    <div id="owl-blog" class="owl-carousel owl-theme owl-loaded">
                        <div class="owl-stage-outer">
                            <div class="owl-stage quadro2">
                                <?php foreach ($posts as $post) : ?>
                                    <div class="owl-item">
                                        <div class="row justify-content-center">
                                            <div class="ms-4 col-11 my-2 my-md-0">
                                                <div class="card">
                                                    <div class="imagem-post" style="background-image:url({{ $post->image }})"></div>
                                                    <div class="card-body text-center">
                                                        <ion-icon name="calendar" style="color: #737373;" class="icone  pe-2"></ion-icon><span style="color: #737373;" class="datas"><?= date_format(date_create($post->updated_at), 'd/m/Y') ?></span>
                                                        <h5 class="card-title pt-2"><?= $post->title ?></h5>
                                                    </div>
                                                    <div class="row justify-content-center align-items-center g-0">
                                                        <div class="col-12 col-lg-5 text-center pb-3">
                                                            <a href="{{ route('postEstetica', $post->id) }}" class="btn btn-blog-mais">VER MAIS <ion-icon name="caret-forward" class="icone-bt"></ion-icon></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <div class="col-12 text-center mb-5">
                                <a href={{route("blogEstetica")}} class="btn btn-blog">Blog</a>
                            </div>
                        </div>
                        <!-- <div class="owl-nav d-none d-md-block">
                            <div class="owl-prev d-none d-md-block"></div>
                            <div class="owl-next d-none d-md-block"></div>
                        </div> -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</section> --}}

<section id="banner">
    <div class="container-fluid">
        <div class="row justify-content-center text-center w-100">
            <div class="col-11 col-md-9 col-lg-6 box">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <h2>Vamos conversar?</h2>
                    </div>
                    <div class="col-12 col-lg-10 my-3">
                        <p>
                            Mande uma mensagem a qualquer momento para tirar suas dúvidas e conversar.
                        </p>
                    </div>
                    <div class="col-12 col-lg-4 mb-3 text-break">
                        <span>
                            <ion-icon class="icon" name="logo-whatsapp"></ion-icon> (19) 9 9369-8413
                        </span>
                    </div>
                    <div class="col-12 col-lg-5 mt-lg-1 mb-3 text-break">
                        <a href="https://web.whatsapp.com/send?phone=5519993698413" target="_blank">
                            Fale comigo agora mesmo<!--<ion-icon class="arrow" name="chevron-forward">-->
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@include('include.footer')
@endsection

@section('script')

@endsection
