@section('description', $post->description)

@section('tags', $post->tags)
@section('image', asset("/img/logo.png"))

@extends('layouts.app')
@section('title', 'Blog - ' . config('app.name'))
@include('include.menu-atendimento')
@section('head')
<link href="{{ asset('css/blog.css') }}" rel="stylesheet">
<link href="{{ asset('css/menu-blog.css') }}" rel="stylesheet">
<link href="{{ asset('css/menu-atendimento.css') }}" rel="stylesheet">
@endsection

@section('content')

<div class="cor-roxa col-12 px-0">
    <div class="row justify-content-center text-center w-100">
        <div class="col-12 ">
            <h1 class="">Um pouco mais sobre odontologia</h1>
        </div>
        <div class="col-12 col-lg-8">
            <h2>
                O Lorem Ipsum é um texto modelo da indústria tipográfica e de impressão. O Lorem Ipsum tem vindo a ser o texto padrão usado por estas indústrias desde o ano de 1500.
            </h2>
        </div>
    </div>
</div>

<div id="noticias1" class="noticias">
	<div class="container">
		<div class="row">
			<div class="col-lg-7 text-center text-lg-start">
				<div class="row">
					<h4><?php echo $post->title; ?></h4>
					<div class="hr"></div>
					<div class="data pb-3">
						<i class="fa fa-clock-o" aria-hidden="true" style="color:#F1D449"></i> {{ date_format(date_create($post->created_at), "d/m/Y") }}
					</div>
						<div class="noticias-img mb-5" style="background-image:url('{{ $post->image }}');">
						</div>

					<div style="text-align: justify; ">
						{!! $post->content !!}
					</div>
				</div>
				<hr />
				<a href="{{ route('blog-atendimento') }}" class="btn btn-default" style="font-family: montserrat; border-radius: 4px; background-color: #8b519f; color: white; margin-bottom:10px;">Voltar </a>
			</div>

			<div class="col-lg-3 noticias-lateral text-center">
				<img src="/img/logo.png" class="img-fluid center-block wow fadeInRight hidden-xs img-fluid" data-wow-delay="0.2s">
				<hr class="hidden-xs" />

				<div class="wow fadeInRight" data-wow-delay="0.4s">
					<h4 align="center" style="color:#002B4E">Últimas Postagens</h4>
				@foreach($posts as $ul_post)
							<a style="color:black" href='{{ route('postAtendimento', $ul_post->id) }}'> - {{ $ul_post->title }}</a>
							<br />
							@endforeach
					<br />
				</div>
				<hr />

				<h4 align="center" class="wow fadeInRight" data-wow-delay="1s">Arquivos</h4>
				{!! $arquivo !!}

			</div>
		</div>
	</div>
</div>
<section id="contato">
    <div class="container-fluid">
        <div class="row justify-content-center row1 text-lg-start text-center">
            <div class="col-12 col-md-8 col-lg-5 me-lg-5 mt-lg-4">
                <div class="row justify-content-center">
                    <h2>Nós vamos até você!</h2>
                    <p>
                        Nossa área de atuação principal é na região de Indaiatuba, Campinas e Jundiaí. Se você reside em outras localidades, entre em contato.
                    </p>
                </div>
            </div>
            <div class="col-12 col-lg-4">
                <div class="row justify-content-center">
                    <div class="col-12 col-lg-1">
                        <ion-icon class="info-icon" name="logo-whatsapp"></ion-icon>
                    </div>
                    <div class="col-12 col-lg-11 my-2">
                        <a href="https://api.whatsapp.com/send?phone=5519993698413" target="_blank">
                            <span>
                                (19) 9 9369-8413
                            </span>
                        </a>
                    </div>
                    <div class="col-12 col-lg-1 mt-2">
                        <ion-icon class="info-icon" name="mail"></ion-icon>
                    </div>
                    <div class="col-12 col-lg-11 my-3 pt-2 pt-lg-0 text-break">
                        <a href="mailto:contato@dentistanasuacasa.com.br">
                            <span>contato@dentistanasuacasa.com.br</span>
                        </a>
                    </div>
                    <div class="col-12 col-lg-1">
                        <ion-icon class="info-icon" name="location"></ion-icon>
                    </div>
                    <div class="col-12 col-lg-11 mt-2 pt-3 pt-lg-0 text-break">
                        <a href="https://g.page/dentista-na-sua-casa?share" target="_blank">
                            <span>
                                Indaiatuba, Campinas e região
                            </span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <iframe class="m-0" src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d469818.0197558803!2d-47.07772!3d-23.0804971!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x14103b4aca1c7276!2sDentista%20na%20sua%20casa!5e0!3m2!1spt-BR!2sbr!4v1648655479345!5m2!1spt-BR!2sbr" width="100%" height="350" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
</section>
@include('include.footer')
@endsection


