<?php

use App\Http\Controllers\{
    IntranetController
};

use App\Http\Controllers\API\UpdateController;

use Illuminate\Support\Facades\{
    Auth,
    Route
};


# Irá habilitar o registro no intranet apenas se estiver em modo DEBUG
env('APP_DEBUG') ? Auth::routes() : Auth::routes(['register' => false]);

# Rotas padrão Intranet
Auth::routes();
Route::middleware(['auth'])->group(function () {
    Route::get('/', [IntranetController::class, 'index'])->name('intranetIndex');
    Route::get('/minhaconta', [IntranetController::class, 'minhaconta'])->name('intranetMinhaconta');
    Route::put('/minhaconta', [IntranetController::class, 'updateminhaconta']);

    Route::get('/novaconta', [IntranetController::class, 'novaconta'])->name('intranetNovaconta');
    Route::post('/novaconta', [IntranetController::class, 'storeconta']);

    Route::get('/editarusuario/{id}', [IntranetController::class, 'editarusuario'])->name('intranetEditarusuario');
    Route::put('/editarusuario/{id}', [IntranetController::class, 'updateusuario']);
    Route::delete('/editarusuario/{id}', [IntranetController::class, 'destroyusuario'])->name('intranetDestroyusuario');


    Route::get('/usuarios', [IntranetController::class, 'usuarios'])->name('intranetUsuarios');
});

# Rota de API (/intranet/api)
Route::prefix('api')->group(function () {
    # Atualizador de módulos
    # Exemplo de uso: /intranet/api/update/mpsoft-digital/clientes-module
    # RECURSO EM FASE DE TESTE, POR FAVOR NÃO USAR EM PRODUÇÃO!
    // Route::get('update/{vendor}/{repo}', [UpdateController::class, 'run']);
    // Route::get('update/{vendor}/{repo}/{version}', [UpdateController::class, 'run']);
});
