<?php

use App\Http\Controllers\{
    HomeController,
    SitemapXmlController,
};

use App\Http\Controllers\API\UpdateController;

use Illuminate\Support\Facades\{
    Route
};
use Modules\Contato\Http\Controllers\ContatoFrontController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Aqui é onde você pode registrar as rotas para a aplicação. Essas
| rotas serão responsáveis por ler o endereço URL da página
| e encaminhar para uma classe que retornará o conteúdo da mesma!
|
*/

# Rota intranet
# Carrega rotas específicas do intranet, por favor, não alterar
Route::prefix('intranet')->group(function () {
    file_exists(dirname(__FILE__) . '/intranet.php') ? include_once 'intranet.php' : false;
});

# Gera sitemap dinâmico do site
Route::get('/sitemap.xml', [SitemapXmlController::class, 'index']);

# Rotas site
Route::get('/', [HomeController::class, 'index'])->name('index');
Route::get('/home', [HomeController::class, 'index'])->name('home');
Route::get('/atendimento-em-casa', [HomeController::class, 'atendimento'])->name('atendimento');
Route::get('/tratamentos-estéticos', [HomeController::class, 'estetica'])->name('estetica');
//Route::get('/blog-estetica', [HomeController::class, 'blogEstetica'])->name('blogEstetica');
//Route::get('/blog-atendimento', [HomeController::class, 'blogAtendimento'])->name('blogAtendimento');
//Route::get('/blog-atendimento/post-atendimento/{id}', [HomeController::class, 'postAtendimento'])->name('postAtendimento');
//Route::get('/blog-estetica/post-estetica/{id}', [HomeController::class, 'postEstetica'])->name('postEstetica');
